package com.kboxglobal.customer.profile.db;

import com.kboxglobal.customer.profile.ProfileView;
import com.kboxglobal.customer.profile.ProfileViewDao;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Dependency inversion adapter to separate data access method from use case implementations
 */
@Component
public class DbAdapter implements ProfileViewDao {
	private final ProfileViewEntityRepo repo;

	public DbAdapter(ProfileViewEntityRepo repo) {
		this.repo = repo;
	}

	@Override
	public void save(ProfileView profileView) {
		repo.save(toEntity(profileView));
	}

	@Override
	public List<ProfileView> getProfileViews(Long userId, int maxRecords, Duration farBack) {
		return repo.findByUserIdAndDateTimeAfter(userId, ZonedDateTime.now().minus(farBack), PageRequest.of(0, maxRecords))
				.stream()
				.map(this::toModel)
				.collect(Collectors.toList());
	}

	private ProfileViewEntity toEntity(ProfileView model) {
		ProfileViewEntity pve = new ProfileViewEntity();
		pve.setUserId(model.getUserId());
		pve.setViewerId(model.getViewerId());
		pve.setDateTime(model.getDateTime());
		return pve;
	}

	private ProfileView toModel(ProfileViewEntity entity) {
		return new ProfileView(entity.getUserId(), entity.getViewerId(), entity.getDateTime());
	}
}
