package com.kboxglobal.customer.profile.api;

import com.kboxglobal.customer.profile.GetProfileViewsUC;
import com.kboxglobal.customer.profile.ProfileView;
import com.kboxglobal.customer.profile.RecordProfileViewUC;
import org.springframework.web.bind.annotation.*;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/profile")
public class ProfileViewController {

	private final RecordProfileViewUC recordProfileViewUC;
	private final GetProfileViewsUC getProfileViewsUC;

	public ProfileViewController(RecordProfileViewUC recordProfileViewUC, GetProfileViewsUC getProfileViewsUC) {
		this.recordProfileViewUC = recordProfileViewUC;
		this.getProfileViewsUC = getProfileViewsUC;
	}

	@PostMapping("/{userId}/view")
	public void recordView(@PathVariable long userId, @RequestBody RecordViewRequest request) {
		ProfileView profileView = new ProfileView(userId, request.viewerId, ZonedDateTime.now());
		recordProfileViewUC.saveProfileView(profileView);
	}

	@GetMapping("/{userId}/view")
	public List<ProfileViewsResponse> getProfileViews(@PathVariable long userId) {
		List<ProfileView> profileViews = getProfileViewsUC.getProfileViews(userId);
		return profileViews.stream()
				.map(pv -> new ProfileViewsResponse(pv.getViewerId(), pv.getDateTime()))
				.collect(Collectors.toList());
	}
}
