package com.kboxglobal.customer.profile;

import java.time.ZonedDateTime;
import java.util.Objects;

public class ProfileView {
	private Long userId;
	private Long viewerId;
	private ZonedDateTime dateTime;

	public ProfileView(Long userId, Long viewerId, ZonedDateTime dateTime) {
		this.userId = userId;
		this.viewerId = viewerId;
		this.dateTime = dateTime;
	}

	public Long getUserId() {
		return userId;
	}

	public Long getViewerId() {
		return viewerId;
	}

	public ZonedDateTime getDateTime() {
		return dateTime;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		ProfileView that = (ProfileView) o;
		return userId.equals(that.userId) && viewerId.equals(that.viewerId) && dateTime.equals(that.dateTime);
	}

	@Override
	public int hashCode() {
		return Objects.hash(userId, viewerId, dateTime);
	}
}
