package com.kboxglobal.customer.profile;

import org.springframework.stereotype.Component;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;

/**
 * Use Case class to get profile views of a user
 */
@Component
public class GetProfileViewsUC {
	private final ProfileViewDao profileViewDao;

	public GetProfileViewsUC(ProfileViewDao profileViewDao) {
		this.profileViewDao = profileViewDao;
	}

	public List<ProfileView> getProfileViews(long userId) {
		return profileViewDao.getProfileViews(userId, 20, Duration.ofDays(30));
	}
}
