/*
 * Decompiled with CFR 0.152.
 */
package tr.com.innova.kafkaprinter;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.kafka.annotation.KafkaListener;

@SpringBootApplication
public class KafkaPrinterApplication {
    public static void main(String[] args) {
        SpringApplication.run(KafkaPrinterApplication.class, (String[])args);
    }

    @KafkaListener(topics={"oim-events", "oim-parameters", "oimcustomer-snapshot", "quota-keys", "quota-results", "captcha-results"})
    public void listen(ConsumerRecord<String, String> cr) throws Exception {
        this.printMessagePrintf(cr);
    }

    private void printMessagePrintf(ConsumerRecord<String, String> cr) {
        System.out.printf("%-20s | %-40s | %-100s" + System.lineSeparator(), cr.topic(), cr.key(), cr.value());
    }
}

